# Aggressor Adventures Document Library - Deployment Overview

## Complete Package Contents

Your self-contained LAMP web application is now ready for deployment. Here's what has been created:

### 📁 **Core Application Files**

1. **`index.php`** - Main application file
   - Directory scanning logic
   - PDF serving with security validation
   - HTML generation with Aggressor branding
   - Metadata parsing for document descriptions

2. **`assets/style.css`** - Responsive CSS with Aggressor branding
   - Aggressor Adventures color scheme (navy blue, green accents)
   - Mobile-first responsive design
   - Touch-friendly interface optimizations
   - Professional maritime theme

3. **`assets/script.js`** - Interactive JavaScript
   - Real-time search functionality
   - Category toggle/collapse
   - PDF modal viewer
   - Touch gesture support
   - Keyboard navigation

4. **`.htaccess`** - Apache security and optimization
   - File type restrictions
   - Security headers
   - Compression and caching
   - Access control

### 📁 **Deployment & Configuration**

5. **`deploy.sh`** - Automated deployment script
   - Checks system requirements
   - Enables Apache modules
   - Sets proper permissions
   - Configures installation

6. **`apache-vhost.conf`** - Virtual host template
   - Production-ready Apache configuration
   - Security settings
   - SSL-ready (commented out)

7. **`README.md`** - Comprehensive documentation
   - Installation instructions
   - Configuration options
   - Troubleshooting guide
   - Maintenance procedures

### 📁 **Sample Structure**

8. **`docs/`** - Document storage directory with examples:
   ```
   docs/
   ├── Safety/
   │   ├── emergency-procedures.json (sample metadata)
   │   └── safety-briefing.txt (sample metadata)
   ├── Dive Information/
   │   └── dive-sites.json (sample metadata)
   └── Itineraries/
       └── 7-day-bahamas.txt (sample metadata)
   ```

## 🚀 **Quick Deployment Guide**

### Option 1: Automated Deployment (Recommended)

```bash
# 1. Copy files to your Ubuntu server
scp -r * user@your-server:/tmp/docs-app/

# 2. SSH to your server
ssh user@your-server

# 3. Run the deployment script
cd /tmp/docs-app/
sudo ./deploy.sh
```

### Option 2: Manual Deployment

```bash
# 1. Install prerequisites
sudo apt update
sudo apt install apache2 php libapache2-mod-php

# 2. Enable Apache modules
sudo a2enmod rewrite headers expires deflate

# 3. Copy files
sudo cp -r * /var/www/html/docs/

# 4. Set permissions
sudo chown -R www-data:www-data /var/www/html/docs/
sudo chmod -R 755 /var/www/html/docs/

# 5. Restart Apache
sudo systemctl restart apache2
```

## 📋 **Directory Structure for Production**

```
/var/www/html/docs/
├── index.php                    # Main application
├── .htaccess                    # Apache config
├── assets/
│   ├── style.css               # Aggressor-branded CSS
│   └── script.js               # Interactive features
├── docs/                       # PDF storage
│   ├── Safety/                 # Category folder
│   │   ├── emergency-procedures.pdf
│   │   ├── emergency-procedures.json  # Optional metadata
│   │   ├── safety-briefing.pdf
│   │   └── safety-briefing.txt        # Optional metadata
│   ├── Dive Information/       # Category folder
│   │   ├── dive-sites.pdf
│   │   ├── dive-sites.json
│   │   ├── equipment-guide.pdf
│   │   └── marine-life-guide.pdf
│   └── Itineraries/           # Category folder
│       ├── 7-day-bahamas.pdf
│       ├── 7-day-bahamas.txt
│       ├── 10-day-belize.pdf
│       └── 14-day-galapagos.pdf
└── README.md                   # Documentation
```

## 🎨 **Aggressor Branding Features**

- **Colors**: Deep navy blue (#1e3a5f) primary, green (#38a169) accents
- **Typography**: Open Sans font family (loaded from Google Fonts)
- **Layout**: Clean, professional maritime theme
- **Responsive**: Mobile-first design optimized for tablets and laptops
- **Touch-friendly**: Large buttons, swipe gestures, touch interactions

## 🔒 **Security Features**

- **File validation**: Only PDF files can be served
- **Path traversal protection**: Prevents access outside docs directory
- **XSS protection**: Content Security Policy and input sanitization
- **Access control**: Blocks sensitive files and directories
- **MIME type enforcement**: Proper content type headers

## 📱 **Mobile Optimization**

- **Responsive grid**: Cards stack on narrow screens
- **Touch gestures**: Tap to expand categories, swipe-friendly
- **Fast loading**: Optimized for yacht Wi-Fi connections
- **Offline-ready**: All assets served locally

## 🔍 **Search Functionality**

- **Real-time filtering**: Search as you type
- **Multi-term search**: Supports multiple keywords
- **Category search**: Searches category names too
- **Description search**: Includes metadata descriptions
- **Highlight results**: Visual highlighting of search terms

## 📄 **PDF Viewing**

- **Embedded viewer**: Uses browser's native PDF support
- **Modal interface**: View without leaving the page
- **Mobile-friendly**: Touch controls for zooming/scrolling
- **Fallback support**: Opens in new tab if modal fails

## 🛠 **Adding Documents**

1. **Create category folders** in `/var/www/html/docs/docs/`
2. **Add PDF files** to appropriate categories
3. **Optional**: Add `.json` or `.txt` files for descriptions
4. **Set permissions**: `sudo chown -R www-data:www-data /var/www/html/docs/docs/`

## 📞 **Support & Maintenance**

- **No database required**: File-based system
- **Auto-discovery**: New files appear immediately
- **Easy backup**: Just backup the docs/ directory
- **Log monitoring**: Check Apache logs for issues
- **Performance**: Optimized for 100+ documents per category

## 🌐 **Access Your Library**

After deployment, access your document library at:
- **Local network**: `http://your-server-ip/`
- **Custom domain**: Configure DNS to point to your server
- **HTTPS**: Use the SSL configuration in `apache-vhost.conf`

---

**Your Aggressor Adventures Document Library is now ready for deployment on your yacht's Ubuntu-based intranet system!**
